/*=============================================================================
	UnCoreNative.h: Native function lookup table for static libraries.
	Copyright 2000 Epic Games, Inc. All Rights Reserved.

	Revision history:
		* Created by Brandon Reinhart
=============================================================================*/

#include "CorePrivate.h"

#if __STATIC_LINK
UObjectNativeInfo GCoreUObjectNatives[] =
{
	MAP_NATIVE( UObject, execLocalVariable )
	MAP_NATIVE( UObject, execInstanceVariable )
	MAP_NATIVE( UObject, execDefaultVariable )
	MAP_NATIVE( UObject, execClassContext )
	MAP_NATIVE( UObject, execArrayElement )
	MAP_NATIVE( UObject, execDynArrayElement )
	MAP_NATIVE( UObject, execDynArrayLength )
	MAP_NATIVE( UObject, execDynArrayInsert )
	MAP_NATIVE( UObject, execDynArrayRemove )
	MAP_NATIVE( UObject, execPrimitiveCast )
	MAP_NATIVE( UObject, execBoolVariable )
	MAP_NATIVE( UObject, execStructMember )
	MAP_NATIVE( UObject, execNothing )
	MAP_NATIVE( UObject, execEndOfScript )
	MAP_NATIVE( UObject, execNativeParm )
	MAP_NATIVE( UObject, execEndFunctionParms )
	MAP_NATIVE( UObject, execStop )
	MAP_NATIVE( UObject, execSwitch )
	MAP_NATIVE( UObject, execCase )
	MAP_NATIVE( UObject, execJump )
	MAP_NATIVE( UObject, execJumpIfNot )
	MAP_NATIVE( UObject, execAssert )
	MAP_NATIVE( UObject, execGotoLabel )
	MAP_NATIVE( UObject, execLet )
	MAP_NATIVE( UObject, execLetBool )
	MAP_NATIVE( UObject, execLetDelegate )
	MAP_NATIVE( UObject, execSelf )
	MAP_NATIVE( UObject, execContext )
	MAP_NATIVE( UObject, execVirtualFunction )
	MAP_NATIVE( UObject, execFinalFunction )
	MAP_NATIVE( UObject, execGlobalFunction )
	MAP_NATIVE( UObject, execStructCmpEq )
	MAP_NATIVE( UObject, execStructCmpNe )
	MAP_NATIVE( UObject, execIntConst )
	MAP_NATIVE( UObject, execFloatConst )
	MAP_NATIVE( UObject, execStringConst )
	MAP_NATIVE( UObject, execUnicodeStringConst )
	MAP_NATIVE( UObject, execObjectConst )
	MAP_NATIVE( UObject, execNameConst )
	MAP_NATIVE( UObject, execByteConst )
	MAP_NATIVE( UObject, execIntZero )
	MAP_NATIVE( UObject, execIntOne )
	MAP_NATIVE( UObject, execTrue )
	MAP_NATIVE( UObject, execFalse )
	MAP_NATIVE( UObject, execNoObject )
	MAP_NATIVE( UObject, execIntConstByte )
	MAP_NATIVE( UObject, execDynamicCast )
	MAP_NATIVE( UObject, execMetaCast )
	MAP_NATIVE( UObject, execByteToInt )
	MAP_NATIVE( UObject, execByteToBool )
	MAP_NATIVE( UObject, execByteToFloat )
	MAP_NATIVE( UObject, execByteToString )
	MAP_NATIVE( UObject, execIntToByte )
	MAP_NATIVE( UObject, execIntToBool )
	MAP_NATIVE( UObject, execIntToFloat )
	MAP_NATIVE( UObject, execIntToString )
	MAP_NATIVE( UObject, execBoolToByte )
	MAP_NATIVE( UObject, execBoolToInt )
	MAP_NATIVE( UObject, execBoolToFloat )
	MAP_NATIVE( UObject, execBoolToString )
	MAP_NATIVE( UObject, execFloatToByte )
	MAP_NATIVE( UObject, execFloatToInt )
	MAP_NATIVE( UObject, execFloatToBool )
	MAP_NATIVE( UObject, execFloatToString )
	MAP_NATIVE( UObject, execObjectToBool )
	MAP_NATIVE( UObject, execObjectToString )
	MAP_NATIVE( UObject, execNameToBool )
	MAP_NATIVE( UObject, execNameToString )
	MAP_NATIVE( UObject, execStringToByte )
	MAP_NATIVE( UObject, execStringToInt )
	MAP_NATIVE( UObject, execStringToBool )
	MAP_NATIVE( UObject, execStringToFloat )
	MAP_NATIVE( UObject, execNot_PreBool )
	MAP_NATIVE( UObject, execEqualEqual_BoolBool )
	MAP_NATIVE( UObject, execNotEqual_BoolBool )
	MAP_NATIVE( UObject, execAndAnd_BoolBool )
	MAP_NATIVE( UObject, execXorXor_BoolBool )
	MAP_NATIVE( UObject, execOrOr_BoolBool )
	MAP_NATIVE( UObject, execMultiplyEqual_ByteByte )
	MAP_NATIVE( UObject, execDivideEqual_ByteByte )
	MAP_NATIVE( UObject, execAddEqual_ByteByte )
	MAP_NATIVE( UObject, execSubtractEqual_ByteByte )
	MAP_NATIVE( UObject, execAddAdd_PreByte )
	MAP_NATIVE( UObject, execSubtractSubtract_PreByte )
	MAP_NATIVE( UObject, execAddAdd_Byte )
	MAP_NATIVE( UObject, execSubtractSubtract_Byte )
	MAP_NATIVE( UObject, execComplement_PreInt )
	MAP_NATIVE( UObject, execGreaterGreaterGreater_IntInt )
	MAP_NATIVE( UObject, execSubtract_PreInt )
	MAP_NATIVE( UObject, execMultiply_IntInt )
	MAP_NATIVE( UObject, execDivide_IntInt )
	MAP_NATIVE( UObject, execAdd_IntInt )
	MAP_NATIVE( UObject, execSubtract_IntInt )
	MAP_NATIVE( UObject, execLessLess_IntInt )
	MAP_NATIVE( UObject, execGreaterGreater_IntInt )
	MAP_NATIVE( UObject, execLess_IntInt )
	MAP_NATIVE( UObject, execGreater_IntInt )
	MAP_NATIVE( UObject, execLessEqual_IntInt )
	MAP_NATIVE( UObject, execGreaterEqual_IntInt )
	MAP_NATIVE( UObject, execEqualEqual_IntInt )
	MAP_NATIVE( UObject, execNotEqual_IntInt )
	MAP_NATIVE( UObject, execAnd_IntInt )
	MAP_NATIVE( UObject, execXor_IntInt )
	MAP_NATIVE( UObject, execOr_IntInt )
	MAP_NATIVE( UObject, execMultiplyEqual_IntFloat )
	MAP_NATIVE( UObject, execDivideEqual_IntFloat )
	MAP_NATIVE( UObject, execAddEqual_IntInt )
	MAP_NATIVE( UObject, execSubtractEqual_IntInt )
	MAP_NATIVE( UObject, execAddAdd_PreInt )
	MAP_NATIVE( UObject, execSubtractSubtract_PreInt )
	MAP_NATIVE( UObject, execAddAdd_Int )
	MAP_NATIVE( UObject, execSubtractSubtract_Int )
	MAP_NATIVE( UObject, execRand )
	MAP_NATIVE( UObject, execMin )
	MAP_NATIVE( UObject, execMax )
	MAP_NATIVE( UObject, execClamp )
	MAP_NATIVE( UObject, execSubtract_PreFloat )
	MAP_NATIVE( UObject, execMultiplyMultiply_FloatFloat )
	MAP_NATIVE( UObject, execMultiply_FloatFloat )
	MAP_NATIVE( UObject, execDivide_FloatFloat )
	MAP_NATIVE( UObject, execPercent_FloatFloat )
	MAP_NATIVE( UObject, execAdd_FloatFloat )
	MAP_NATIVE( UObject, execSubtract_FloatFloat )
	MAP_NATIVE( UObject, execLess_FloatFloat )
	MAP_NATIVE( UObject, execGreater_FloatFloat )
	MAP_NATIVE( UObject, execLessEqual_FloatFloat )
	MAP_NATIVE( UObject, execGreaterEqual_FloatFloat )
	MAP_NATIVE( UObject, execEqualEqual_FloatFloat )
	MAP_NATIVE( UObject, execNotEqual_FloatFloat )
	MAP_NATIVE( UObject, execComplementEqual_FloatFloat )
	MAP_NATIVE( UObject, execMultiplyEqual_FloatFloat )
	MAP_NATIVE( UObject, execDivideEqual_FloatFloat )
	MAP_NATIVE( UObject, execAddEqual_FloatFloat )
	MAP_NATIVE( UObject, execSubtractEqual_FloatFloat )
	MAP_NATIVE( UObject, execAbs )
	MAP_NATIVE( UObject, execSin )
	MAP_NATIVE( UObject, execCos )
	MAP_NATIVE( UObject, execTan )
	MAP_NATIVE( UObject, execAtan )
	MAP_NATIVE( UObject, execExp )
	MAP_NATIVE( UObject, execLoge )
	MAP_NATIVE( UObject, execSqrt )
	MAP_NATIVE( UObject, execSquare )
	MAP_NATIVE( UObject, execFRand )
	MAP_NATIVE( UObject, execFMin )
	MAP_NATIVE( UObject, execFMax )
	MAP_NATIVE( UObject, execFClamp )
	MAP_NATIVE( UObject, execLerp )
	MAP_NATIVE( UObject, execSmerp )
    // gam ---
	MAP_NATIVE( UObject, execCeil )
	MAP_NATIVE( UObject, execRound )
    // --- gam
	MAP_NATIVE( UObject, execRotationConst )
	MAP_NATIVE( UObject, execVectorConst )
	MAP_NATIVE( UObject, execStringToVector )
	MAP_NATIVE( UObject, execStringToRotator )
	MAP_NATIVE( UObject, execVectorToBool )
	MAP_NATIVE( UObject, execVectorToString )
	MAP_NATIVE( UObject, execVectorToRotator )
	MAP_NATIVE( UObject, execRotatorToBool )
	MAP_NATIVE( UObject, execRotatorToVector )
	MAP_NATIVE( UObject, execRotatorToString )
	MAP_NATIVE( UObject, execSubtract_PreVector )
	MAP_NATIVE( UObject, execMultiply_VectorFloat )
	MAP_NATIVE( UObject, execMultiply_FloatVector )
	MAP_NATIVE( UObject, execMultiply_VectorVector )
	MAP_NATIVE( UObject, execDivide_VectorFloat )
	MAP_NATIVE( UObject, execAdd_VectorVector )
	MAP_NATIVE( UObject, execSubtract_VectorVector )
	MAP_NATIVE( UObject, execLessLess_VectorRotator )
	MAP_NATIVE( UObject, execGreaterGreater_VectorRotator )
	MAP_NATIVE( UObject, execEqualEqual_VectorVector )
	MAP_NATIVE( UObject, execNotEqual_VectorVector )
	MAP_NATIVE( UObject, execDot_VectorVector )
	MAP_NATIVE( UObject, execCross_VectorVector )
	MAP_NATIVE( UObject, execMultiplyEqual_VectorFloat )
	MAP_NATIVE( UObject, execMultiplyEqual_VectorVector )
	MAP_NATIVE( UObject, execDivideEqual_VectorFloat )
	MAP_NATIVE( UObject, execAddEqual_VectorVector )
	MAP_NATIVE( UObject, execSubtractEqual_VectorVector )
	MAP_NATIVE( UObject, execVSize )
	MAP_NATIVE( UObject, execNormal )
	MAP_NATIVE( UObject, execInvert )
	MAP_NATIVE( UObject, execVRand )
	MAP_NATIVE( UObject, execRotRand )
	MAP_NATIVE( UObject, execMirrorVectorByNormal )
	MAP_NATIVE( UObject, execEqualEqual_RotatorRotator )
	MAP_NATIVE( UObject, execNotEqual_RotatorRotator )
	MAP_NATIVE( UObject, execMultiply_RotatorFloat )
	MAP_NATIVE( UObject, execMultiply_FloatRotator )
	MAP_NATIVE( UObject, execDivide_RotatorFloat )
	MAP_NATIVE( UObject, execMultiplyEqual_RotatorFloat )
	MAP_NATIVE( UObject, execDivideEqual_RotatorFloat )
	MAP_NATIVE( UObject, execAdd_RotatorRotator )
	MAP_NATIVE( UObject, execSubtract_RotatorRotator )
	MAP_NATIVE( UObject, execAddEqual_RotatorRotator )
	MAP_NATIVE( UObject, execSubtractEqual_RotatorRotator )
	MAP_NATIVE( UObject, execGetAxes )
	MAP_NATIVE( UObject, execGetUnAxes )
	MAP_NATIVE( UObject, execOrthoRotation )
	MAP_NATIVE( UObject, execNormalize )
	MAP_NATIVE( UObject, execClockwiseFrom_IntInt )
	MAP_NATIVE( UObject, execEatString )
	MAP_NATIVE( UObject, execConcat_StringString )
	MAP_NATIVE( UObject, execConcatEqual_StringString )
	MAP_NATIVE( UObject, execAt_StringString )
	MAP_NATIVE( UObject, execAtEqual_StringString )
	MAP_NATIVE( UObject, execLess_StringString )
	MAP_NATIVE( UObject, execGreater_StringString )
	MAP_NATIVE( UObject, execLessEqual_StringString )
	MAP_NATIVE( UObject, execGreaterEqual_StringString )
	MAP_NATIVE( UObject, execEqualEqual_StringString )
	MAP_NATIVE( UObject, execNotEqual_StringString )
	MAP_NATIVE( UObject, execComplementEqual_StringString )
	MAP_NATIVE( UObject, execSubtractEqual_StringString )
	MAP_NATIVE( UObject, execLen )
	MAP_NATIVE( UObject, execInStr )
	MAP_NATIVE( UObject, execMid )
	MAP_NATIVE( UObject, execLeft )
	MAP_NATIVE( UObject, execRight )
	MAP_NATIVE( UObject, execCaps )
	MAP_NATIVE( UObject, execLocs )
	MAP_NATIVE( UObject, execChr )
	MAP_NATIVE( UObject, execAsc )
	MAP_NATIVE( UObject, execDivide )
	MAP_NATIVE( UObject, execSplit )
	MAP_NATIVE( UObject, execStrCmp )
	MAP_NATIVE( UObject, execRepl )
	MAP_NATIVE( UObject, execEval )
	MAP_NATIVE( UObject, execEqualEqual_NameName )
	MAP_NATIVE( UObject, execNotEqual_NameName )
	MAP_NATIVE( UObject, execEqualEqual_ObjectObject )
	MAP_NATIVE( UObject, execNotEqual_ObjectObject )
	MAP_NATIVE( UObject, execLog )
	MAP_NATIVE( UObject, execWarn )
	MAP_NATIVE( UObject, execLocalize )
	MAP_NATIVE( UObject, execNew )
	MAP_NATIVE( UObject, execClassIsChildOf )
	MAP_NATIVE( UObject, execGotoState )
	MAP_NATIVE( UObject, execEnable )
	MAP_NATIVE( UObject, execDisable )
	MAP_NATIVE( UObject, execGetPropertyText )
	MAP_NATIVE( UObject, execSetPropertyText )
	MAP_NATIVE( UObject, execSaveConfig)
	MAP_NATIVE( UObject, execStaticSaveConfig)
	MAP_NATIVE( UObject, execResetConfig)
	MAP_NATIVE( UObject, execClearConfig)	// rjp
	MAP_NATIVE( UObject, execStaticClearConfig )
	MAP_NATIVE( UObject, execGetPerObjectNames )
	MAP_NATIVE( UObject, execGetEnum)
	MAP_NATIVE( UObject, execDynamicLoadObject )
    MAP_NATIVE( UObject, execFindObject )
	MAP_NATIVE( UObject, execIsInState )
	MAP_NATIVE( UObject, execGetStateName )
	MAP_NATIVE( UObject, execHighNative0 )
	MAP_NATIVE( UObject, execHighNative1 )
	MAP_NATIVE( UObject, execHighNative2 )
	MAP_NATIVE( UObject, execHighNative3 )
	MAP_NATIVE( UObject, execHighNative4 )
	MAP_NATIVE( UObject, execHighNative5 )
	MAP_NATIVE( UObject, execHighNative6 )
	MAP_NATIVE( UObject, execHighNative7 )
	MAP_NATIVE( UObject, execHighNative8 )
	MAP_NATIVE( UObject, execHighNative9 )
	MAP_NATIVE( UObject, execHighNative10 )
	MAP_NATIVE( UObject, execHighNative11 )
	MAP_NATIVE( UObject, execHighNative12 )
	MAP_NATIVE( UObject, execHighNative13 )
	MAP_NATIVE( UObject, execHighNative14 )
	MAP_NATIVE( UObject, execHighNative15 )
	MAP_NATIVE( UObject, execIsA )
	MAP_NATIVE( UObject, execIterator )
	MAP_NATIVE( UObject, execFindObject )
	MAP_NATIVE( UObject, execClockwiseFrom_IntInt )
	MAP_NATIVE( UObject, execInterpCurveEval )
	MAP_NATIVE( UObject, execInterpCurveGetOutputRange )
	MAP_NATIVE( UObject, execInterpCurveGetInputDomain )
	MAP_NATIVE( UObject, execQuatProduct )
	MAP_NATIVE( UObject, execQuatInvert )
	MAP_NATIVE( UObject, execQuatRotateVector )
	MAP_NATIVE( UObject, execQuatFindBetween )
	MAP_NATIVE( UObject, execQuatFromAxisAndAngle )
	MAP_NATIVE( UObject, execQuatFromRotator )
	MAP_NATIVE( UObject, execQuatToRotator )
	MAP_NATIVE( UObject, execQuatSlerp )
	MAP_NATIVE( UObject, execAcos )
	MAP_NATIVE( UObject, execAsin )
    MAP_NATIVE( UObject, execIsOnConsole ) // amb
    MAP_NATIVE( UObject, execStopWatch ) // amb
	MAP_NATIVE( UObject, execIsSoaking ) // gam
	MAP_NATIVE( UObject, execAllObjects ) // amb
	MAP_NATIVE( UObject, execGetReferencers ) // rjp
	MAP_NATIVE( UObject, execPlatformIsMacOS )
	MAP_NATIVE( UObject, execPlatformIsUnix )
	MAP_NATIVE( UObject, execPlatformIsWindows )
	MAP_NATIVE( UObject, execPlatformIs64Bit )
	{NULL, NULL}
};

UCommandletNativeInfo GCoreUCommandletNatives[] =
{
	MAP_NATIVE( UCommandlet, execMain )
	{NULL, NULL}
};

NativeLookup GNativeLookupFuncs[128];

IMPLEMENT_NATIVE_HANDLER(Core, UObject);
IMPLEMENT_NATIVE_HANDLER(Core, UCommandlet);

#endif

